/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.Enumeration;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.apache.harmony.jndi.internal.nls.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSName
implements Name,
Cloneable {
    private static final long serialVersionUID = -5931312723719884197L;
    private Vector<String> components;

    public DNSName() {
        this.components = new Vector();
    }

    DNSName(Vector<String> compVect) {
        this.components = compVect;
    }

    @Override
    public int size() {
        return this.components.size();
    }

    @Override
    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    public boolean isAbsolute() {
        String el0;
        return this.components.size() > 0 && (el0 = this.components.get(0)) != null && el0.length() == 0;
    }

    @Override
    public Object clone() {
        Vector<String> compClone = new Vector<String>();
        Enumeration<String> compEnum = this.components.elements();
        while (compEnum.hasMoreElements()) {
            compClone.addElement(compEnum.nextElement());
        }
        return new DNSName(compClone);
    }

    @Override
    public Object remove(int posn) throws InvalidNameException {
        return this.components.remove(posn);
    }

    @Override
    public int compareTo(Object name) {
        DNSName nameToCompareWith = null;
        if (name == null) {
            throw new NullPointerException(Messages.getString("jndi.2E"));
        }
        if (!(name instanceof DNSName)) {
            throw new ClassCastException(Messages.getString("jndi.2F"));
        }
        nameToCompareWith = (DNSName)name;
        Enumeration<String> enum1 = this.getAll();
        Enumeration<String> enum2 = nameToCompareWith.getAll();
        while (enum1.hasMoreElements()) {
            String comp1 = enum1.nextElement();
            if (!enum2.hasMoreElements()) {
                return 1;
            }
            String comp2 = enum2.nextElement();
            int k = comp1.compareToIgnoreCase(comp2);
            if (k == 0) continue;
            return k;
        }
        if (enum2.hasMoreElements()) {
            return -1;
        }
        return 0;
    }

    @Override
    public String get(int posn) {
        return this.components.elementAt(posn);
    }

    @Override
    public Enumeration<String> getAll() {
        return this.components.elements();
    }

    @Override
    public Name getPrefix(int posn) {
        Vector<String> prefix = new Vector<String>();
        int i = 0;
        while (i < posn) {
            prefix.addElement(this.components.elementAt(i));
            ++i;
        }
        return new DNSName(prefix);
    }

    @Override
    public Name getSuffix(int posn) {
        Vector<String> prefix = new Vector<String>();
        int i = posn;
        while (i < this.components.size()) {
            prefix.addElement(this.components.elementAt(i));
            ++i;
        }
        return new DNSName(prefix);
    }

    @Override
    public boolean endsWith(Name name) {
        int len2;
        int k = -1;
        if (name == null) {
            return false;
        }
        if (!(name instanceof DNSName)) {
            return false;
        }
        int len1 = this.size();
        if (len1 == (len2 = name.size())) {
            try {
                k = this.compareTo(name);
            }
            catch (ClassCastException classCastException) {}
        } else if (len1 > len2) {
            Name suffix = this.getSuffix(len1 - len2);
            k = suffix.compareTo(name);
        }
        return k == 0;
    }

    @Override
    public boolean startsWith(Name name) {
        int len2;
        int k = -1;
        if (name == null) {
            return false;
        }
        if (!(name instanceof DNSName)) {
            return false;
        }
        int len1 = this.size();
        if (len1 == (len2 = name.size())) {
            try {
                k = this.compareTo(name);
            }
            catch (ClassCastException classCastException) {}
        } else if (len1 > len2) {
            Name prefix = this.getPrefix(len2);
            k = prefix.compareTo(name);
        }
        return k == 0;
    }

    @Override
    public Name add(int posn, String comp) throws InvalidNameException {
        if (!DNSName.componentIsOk(comp)) {
            throw new InvalidNameException(Messages.getString("jndi.30", comp));
        }
        this.components.insertElementAt(comp, posn);
        return this;
    }

    @Override
    public Name add(String comp) throws InvalidNameException {
        if (!DNSName.componentIsOk(comp)) {
            throw new InvalidNameException(Messages.getString("jndi.30", comp));
        }
        this.components.addElement(comp);
        return this;
    }

    @Override
    public Name addAll(int posn, Name name) throws InvalidNameException {
        if (!(name instanceof DNSName)) {
            throw new InvalidNameException(Messages.getString("jndi.31"));
        }
        Vector<String> newComps = ((DNSName)name).components;
        this.components.addAll(posn, newComps);
        return this;
    }

    @Override
    public Name addAll(Name name) throws InvalidNameException {
        if (!(name instanceof DNSName)) {
            throw new InvalidNameException(Messages.getString("jndi.31"));
        }
        Vector<String> newComps = ((DNSName)name).components;
        this.components.addAll(newComps);
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = this.components.size() - 1;
        while (i >= 0) {
            String comp = this.components.elementAt(i);
            if (sb.length() > 0 || i == 0) {
                sb.append('.');
            }
            if (comp.length() > 0) {
                sb.append(comp);
            }
            --i;
        }
        return sb.toString();
    }

    static boolean componentIsOk(String comp) {
        return comp.indexOf(".") == -1 && comp.length() <= 63;
    }
}

