# Generated by Django 4.2.20 on 2025-05-19 23:16

import django.db.models.fields.json
import django.utils.timezone
from django.db import migrations, models

import debusine.artifacts.models


class Migration(migrations.Migration):
    dependencies = [
        ('db', '0006_fileinartifact_content_type'),
    ]
    replaces = [
        ('db', '0148_alter_collectionitem_created_at_and_more'),
    ]

    operations = [
        migrations.AlterField(
            model_name='collectionitem',
            name='created_at',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AddIndex(
            model_name='collectionitem',
            index=models.Index(
                models.F('parent_collection'),
                django.db.models.fields.json.KeyTextTransform(
                    'component', 'data'
                ),
                models.F('created_at'),
                models.F('removed_at'),
                condition=models.Q(
                    (
                        'category',
                        debusine.artifacts.models.ArtifactCategory[
                            'SOURCE_PACKAGE'
                        ],
                    ),
                    ('child_type', 'a'),
                    (
                        'parent_category',
                        debusine.artifacts.models.CollectionCategory['SUITE'],
                    ),
                ),
                name='db_ci_suite_all_sources_idx',
            ),
        ),
        migrations.AddIndex(
            model_name='collectionitem',
            index=models.Index(
                models.F('parent_collection'),
                django.db.models.fields.json.KeyTextTransform(
                    'component', 'data'
                ),
                django.db.models.fields.json.KeyTextTransform(
                    'architecture', 'data'
                ),
                models.F('created_at'),
                models.F('removed_at'),
                condition=models.Q(
                    (
                        'category',
                        debusine.artifacts.models.ArtifactCategory[
                            'BINARY_PACKAGE'
                        ],
                    ),
                    ('child_type', 'a'),
                    (
                        'parent_category',
                        debusine.artifacts.models.CollectionCategory['SUITE'],
                    ),
                ),
                name='db_ci_suite_all_binaries_idx',
            ),
        ),
    ]
