/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef IFP_GUI_H
#define IFP_GUI_H

#include <QMainWindow>
#include "ifpguiview.h"

class QTextEdit;
class QAction;
class QMenu;

extern ifpGUIView *MainIfpGuiWindow;
extern ifp_progress_info ifpTransferInfo;

class ifp_gui: public QMainWindow
{
    Q_OBJECT

public:
    ifp_gui();
    ~ifp_gui();
    void enableWindow(bool enable);
    void showToolbar();
    void hideToolbar();
    void showToolbarText();
    void hideToolbarText();
    int updateStatus();

protected:
    void closeEvent( QCloseEvent* );

private slots:
    void ifpConnect();
    void ifpTransferProgress();
    void uploadPlayList();
    void uploadSelectedFile();
    void downloadSelectedFile();
    void formatIfpDevice();

    void show_ifp_info();
    void show_radiofreq_info();
    void about();
    void aboutQt();
    void auto_convert();

    void setBatteryStatus(int bStatus);
    void setCapacity(int capSize, int capFree);

    void create_directory(void);
    void rename_file(void);
    void delete_file(void);
    void file_properties(void);
    void align_horizontal(void);
    void align_vertical(void);
    void updateFirmware(void);

private:
    void createActions();
    void createMenus();
    void createToolBars();
    void createStatusBar();
    void readSettings();
    //void writeSettings();

    ifpGUIView *m_view;
    QPrinter *printer;
    QString filename;
    QTimer *connect_timer;
    QTimer *progress_timer;
    QMenu *fileMenu, *viewMenu, *optionsMenu, *helpMenu;

    // Main toolbar
    QToolBar     *ifpToolBar;
    QLabel       *BatteryStatus;
    QLabel       *Capacitylbl;
    QProgressBar *CapacityStatus;

    QAction *ifpConnectAct, *uploadPlayListAct, *show_ifp_infoAct;
    QAction *show_radiofreq_infoAct, *aboutAct, *aboutQtAct;
    QAction *auto_convertAct, *closeAllWindowsAct, *whatsThisAct;
    QAction *uploadFileAct, *downloadFileAct, *formatAct, *updateFirmwareAct;

    QAction *create_directoryAct, *rename_fileAct, *delete_fileAct;
    QAction *file_propertiesAct, *align_horizontalAct, *align_verticalAct;

    int  autoConvertMenuID;
    int  horizontalMenuID;
    int  verticalMenuID;
};

//#ifdef __cplusplus
//extern "C" {
//#endif
//
//    extern ifpGUIView *MainIfpGuiWindow;
//
//#ifdef __cplusplus
//}
//#endif


#endif

