/*
 * Copyright (C) 2021-2023 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#include "shared/source/execution_environment/root_device_environment.h"
#include "shared/source/os_interface/linux/hw_device_id.h"
#include "shared/source/os_interface/linux/os_interface_linux.h"
#include "shared/source/os_interface/windows/os_interface_win.h"

namespace NEO {

bool RootDeviceEnvironment::initOsInterface(std::unique_ptr<HwDeviceId> &&hwDeviceId, uint32_t rootDeviceIndex) {
    if (hwDeviceId->getDriverModelType() == DriverModelType::drm) {
        return initDrmOsInterface(std::move(hwDeviceId), rootDeviceIndex, this);
    } else {
        this->isWddmOnLinuxEnable = true;
        return initWddmOsInterface(std::move(hwDeviceId), this);
    }
}

} // namespace NEO
