/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Block.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/01/15
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __LIST_BLOCK_H__
#define __LIST_BLOCK_H__

#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _LIST_BLOCK_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL BLOCK_LIST *p_block_list;
	GLOBAL BLOCK_LIST_INFO block_list_info;


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _LIST_BLOCK_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int init_block(BLOCK *block);
/*  */
BLOCK_LIST *r_block_list_add_first(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info);
/* BLOCK Data をリストの最初に追加 */
BLOCK_LIST *block_list_add_first(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info);
/* BLOCK Data をリストの最初に追加して、 Undo Baffer に書込む */
BLOCK_LIST *block_list_add_first_with_undo(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info);


/* BLOCK Data をリストの最後に追加 */
BLOCK_LIST *block_list_add_last(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info);
/* BLOCK Data をリストの最後に追加、 Undo Baffer に書込む */
BLOCK_LIST *block_list_add_last_with_undo(BLOCK *add_block, BLOCK_LIST_INFO *p_block_list_info);

/* BLOCK Data の削除機能 (メモリの削除ではない) */
int block_list_delete(BLOCK_LIST *del_List, BLOCK_LIST_INFO *p_block_list_info);
/* BLOCK Data をリストの最後に追加、 Undo Baffer に書込む */
int block_list_delete_Undo(BLOCK_LIST *del_List, BLOCK_LIST_INFO *p_block_list_info);

/* BLOCK Data を変更する */
BLOCK_LIST *block_list_edit(BLOCK_LIST *point, BLOCK *change_block, BLOCK_LIST_INFO *p_block_list_info);
/* BLOCK Data を変更する、 Undo Baffer に書込む */
BLOCK_LIST *block_list_edit_with_undo(BLOCK_LIST *point, BLOCK *change_block, BLOCK_LIST_INFO *p_block_list_info);

/* リストの総数を調べる */
long block_list_num(BLOCK_LIST_INFO *p_block_list_info);
/* n 番目のデータの検索 */
BLOCK_LIST *block_search_num(long search_number, BLOCK_LIST_INFO *p_block_list_info);
/* データの検索(BLOCK *p_block から BLOCK_LIST を求める) */
BLOCK_LIST *block_search_block(BLOCK *p_block, BLOCK_LIST_INFO *p_block_list_info);
/* BLOCK のデータの検索 (name から BLOCK_LIST を求める) */
BLOCK_LIST *block_search_block_name(char *name, BLOCK_LIST_INFO *p_block_list_info);
/* データの検索(BLOCK *p_block から Data No. の long 値を求める) */
long block_search_block_to_num(BLOCK *p_block, BLOCK_LIST_INFO *p_block_list_info);

/* BLOCK Data をリストから削除 */
int block_list_free(BLOCK_LIST *del_List, BLOCK_LIST_INFO *p_block_list_info);
/* 全リストを削除 */
void block_list_all_free(BLOCK_LIST_INFO *p_block_list_info);

/* BLOCK_LIST のデータ log */
void block_list_log(BLOCK_LIST_INFO *p_block_list_info);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_BLOCK_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Block.h
 * ====================================================================
 */
