/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : StringCulc
 *    Description          : ETC
 *    Source               : StringCulc.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2000/12/07
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __STRINGCULC_H__
#define __STRINGCULC_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */
#define BUFSIZE 256



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _STRINGCULC_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL int Pos;
	GLOBAL char Buf[BUFSIZE];


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _STRINGCULC_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
/* 式の計算をして返す */
double StringCulc(char *expression);
/* 式の計算 */
double s_getexp(void);
/* 項の評価関数 */
double s_gettrm(void);
/* 因子の評価関数 */
double s_getfct(void);
/* 数の評価関数 */
double s_getnum(void);
/* 式のチェック */
int s_stxchk(void);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __STRINGCULC_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : StringCulc
 *    Source               : StringCulc.h
 * ====================================================================
 */
