// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2012 - Scilab Enterprises - Adeline CARNIS
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

// <-- Non-regression test for bug 11653 -->
//
// <-- Bugzilla URL -->
// http://bugzilla.scilab.org/show_bug.cgi?id=11653
//
// <-- Short Description -->
//    Optional booleans in eigs were doubles and are now booleans.
// =============================================================================

// REAL SYMMETRIC PROBLEM
clear opts;
n = 10;
k = 6;
A            = diag(5*ones(n,1));
A(1:$-1,2:$) = A(1:$-1,2:$) + diag(6*ones(n-1,1));
A(2:$,1:$-1) = A(2:$,1:$-1) + diag(6*ones(n-1,1));
A(1:$-3,4:$) = A(1:$-3,4:$) + diag(2*ones(n-3,1));
A(4:$,1:$-3) = A(4:$,1:$-3) + diag(2*ones(n-3,1));
A1 = sparse(A);

opts.cholB = %t;
d1 = eigs(A1, speye(n,n), k, 'LM', opts);
d0 = spec(A);
assert_checkalmostequal(gsort(d1,'g','i'), [d0(1);d0($-4:$)], [], %eps);

d1 = eigs(A, eye(n,n), k, 'LM', opts);
assert_checkalmostequal(gsort(real(d1),'g','i'), [d0(1);d0($-4:$)], [], %eps);

// REAL NON SYMMETRIC PROBLEM
B            = diag(5*ones(n,1));
B(1:$-1,2:$) = B(1:$-1,2:$) + diag(-6*ones(n-1,1));
B(2:$,1:$-1) = B(2:$,1:$-1) + diag(6*ones(n-1,1));
B(1:$-3,4:$) = B(1:$-3,4:$) + diag(-2*ones(n-3,1));
B(4:$,1:$-3) = B(4:$,1:$-3) + diag(2*ones(n-3,1));
B1 = sparse(B);
d0 = spec(B);

d1 = eigs(B1, speye(n,n), k, 'LM', opts);
assert_checkalmostequal(abs(d1), gsort(abs(d0($-5:$)),'g','i'), [], %eps);

d1 = eigs(B, eye(n,n), k, 'LM', opts);
assert_checkalmostequal(abs(d1), gsort(abs(d0($-5:$)),'g','i'), [], %eps);


// COMPLEX PROBLEM
C            = diag(5*ones(n,1)+%i*ones(n,1));
C(1:$-1,2:$) = C(1:$-1,2:$) + diag(6*ones(n-1,1));
C(2:$,1:$-1) = C(2:$,1:$-1) + diag(6*ones(n-1,1));
C(1:$-3,4:$) = C(1:$-3,4:$) + diag(2*ones(n-3,1));
C(4:$,1:$-3) = C(4:$,1:$-3) + diag(2*ones(n-3,1));
C1 = sparse(C);
d0= spec(C);

d1 = eigs(C1, speye(n,n), k, 'LM', opts);
d = gsort(abs(d0));
assert_checkalmostequal(gsort(abs(d1)), d(1:k), [], %eps);

d1 = eigs(C, eye(n,n), k, 'LM', opts);
assert_checkalmostequal(gsort(abs(d1)), d(1:k), [], %eps);


// FUNCTION :
// REAL SYMMETRIC PROBLEM
clear opts
function y = fn(x)
    y = A1 * x;
endfunction

opts.isreal = %t;
opts.issym = %t;

d1 = eigs(fn, n, [], k, 'LM', opts );
d0 = spec(A);
assert_checkalmostequal(gsort(d1,'g','i'), [d0(1);d0($-4:$)], [], %eps);

clear fn
function y = fn(x)
    y = A * x;
endfunction

d1 = eigs(fn, n, [], k, 'LM', opts );
assert_checkalmostequal(gsort(real(d1),'g','i'), [d0(1);d0($-4:$)], [], %eps);

// REAL NON SYMMETRIC PROBLEM
clear fn
function y = fn(x)
    y = B1 * x;
endfunction

opts.isreal = %t;
opts.issym = %f;

d1 = eigs(fn, n, [], k, 'LM', opts );
d0 = spec(B);
assert_checkalmostequal(abs(d1), gsort(abs(d0($-5:$)),'g','i'), [], %eps);

clear fn
//B collides with B inside of feigs, so we rename it ( global variables are evil!)
globalB = B;
function y = fn(x)
    y = globalB * x;
endfunction

d1 = eigs(fn, n, [], k, 'LM', opts );
assert_checkalmostequal(abs(d1), gsort(abs(d0($-5:$)),'g','i'), [], %eps);

// COMPLEX PROBLEM
clear fn
function y = fn(x)
    y = C1 * x;
endfunction

opts.isreal = %f;
opts.issym = %f;

d1 = eigs(fn, n, [], k, 'LM', opts );
d0 = spec(C);
d = gsort(abs(d0));
assert_checkalmostequal(gsort(abs(d1)), d(1:k), [], %eps);

clear fn
function y = fn(x)
    y = C * x;
endfunction

d1 = eigs(fn, n, [], k, 'LM', opts );
assert_checkalmostequal(gsort(abs(d1)), d(1:k), [], %eps);
