#ifndef GETLINE_HH
#define GETLINE_HH
#include <unistd.h>
#include <sys/mman.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>

class Line {
	private:
		int fd;
		char *buffer;
		char *ptr;
		int len;
		int error;
	public:
		Line(const char *filename) {
			fd=open(filename,O_RDONLY);
			error=0;
			if (fd<0) {
				error=errno;
				return;
			}
			len = lseek(fd,0,SEEK_END);
			if (len==-1) {
				error=errno;
				return;
			}
			ptr=buffer=(char*)mmap(0,len,PROT_READ,MAP_SHARED,fd,0);
			madvise(buffer,len,MADV_SEQUENTIAL);
			return;
		}
		int eof() { return !buffer || ptr>=(buffer+len); }
		int getError() { return error; }

		char *getline() {
			char *end;
			if (!buffer)
				return NULL;
			end=ptr;
			while (end<=(buffer+len) && *end!='\x0a') {
				end++;
			}
			char *ret;
			ret=(char *)malloc(end-ptr+2);
			memcpy(ret,ptr,end-ptr);
			ret[end-ptr]='\0';
			ptr=end+1;
			return ret;
		}

		~Line() {
			munmap(buffer,len);
			close(fd);
		}

};

#endif
