/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _BLOCK_INFO_H
#define _BLOCK_INFO_H

// sc
#include "svn/svn.h"


class BlockInfo
{
public:
  BlockInfo() : _start(-1), _length(-1), _originalLength(0), _modifiedLength(0)
  {
  }

  BlockInfo( svn::Offset start, svn::Offset length, svn::Offset originalLength,
    svn::Offset modifiedLength )
  : _start(start), _length(length), _originalLength(originalLength),
    _modifiedLength(modifiedLength)
  {
  }

  svn::Offset getStart() const
  {
    return _start;
  }

  svn::Offset getLength() const
  {
    return _length;
  }

  svn::Offset getOriginalLength() const
  {
    return _originalLength;
  }

  svn::Offset getModifiedLength() const
  {
    return _modifiedLength;
  }
  
  bool isEmpty() const
  {
    return _start == -1;
  }

  void addLength(svn::Offset l)
  {
    _length += l;
  }

private:
  svn::Offset _start;           ///< start, ie. line
  svn::Offset _length;          ///< number of all lines
  svn::Offset _originalLength;  ///< number of original lines
  svn::Offset _modifiedLength;  ///< number of modified lines
};

#endif //  _BLOCK_INFO_H

