/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_INFO_H
#define _SVN_INFO_H

// sc
#include "InfoTypes.h"
#include "svn/svn.h"
#include "util/String.h"

// svn
#include <svn_client.h>


namespace svn
{

// svn_info_t
class Info
{
public:
  Info( const sc::String&, const svn_info_t* );
  Info( const Info& src );
  ~Info();

  const sc::String& getName() const;

  const sc::String& getUrl() const;
  const sc::String& getRootUrl() const;

  Revnumber getRevnumber() const;

private:
  sc::String       _name;

  sc::String       _url;
  sc::String       _root;

  Revnumber        _revnum;
};

} // namespace

#endif // _SVN_INFO_H

