/*
 * ProportionalLayoutPanel.java
 *
 * Created on May 7, 2005, 4:15 AM
 */

package com.kitfox.svg.app.beans;

import java.awt.*;
import java.util.*;
import javax.swing.*;

/**
 * Panel based on the null layout.  Allows editing with absolute layout.  When
 * instanced, records layout dimensions of all subcomponents.  Then, if the
 * panel is ever resized, scales all children to fit new size.
 *
 * @author  kitfox
 */
public class ProportionalLayoutPanel extends javax.swing.JPanel
{
    public static final long serialVersionUID = 1;

    //Margins to leave on sides of panel, expressed in fractions [0 1]
    float topMargin;
    float bottomMargin;
    float leftMargin;
    float rightMargin;
    
    /** Creates new form ProportionalLayoutPanel */
    public ProportionalLayoutPanel()
    {
        initComponents();
    }
    
    public void addNotify()
    {
        super.addNotify();
        
        Rectangle rect = this.getBounds();
        JOptionPane.showMessageDialog(this, "" + rect);
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        jPanel1 = new javax.swing.JPanel();

        setLayout(null);

        addComponentListener(new java.awt.event.ComponentAdapter()
        {
            public void componentResized(java.awt.event.ComponentEvent evt)
            {
                formComponentResized(evt);
            }
            public void componentShown(java.awt.event.ComponentEvent evt)
            {
                formComponentShown(evt);
            }
        });

        add(jPanel1);
        jPanel1.setBounds(80, 90, 280, 160);

    }
    // </editor-fold>//GEN-END:initComponents

    private void formComponentShown(java.awt.event.ComponentEvent evt)//GEN-FIRST:event_formComponentShown
    {//GEN-HEADEREND:event_formComponentShown
        JOptionPane.showMessageDialog(this, "" + getWidth() + ", " + getHeight());

    }//GEN-LAST:event_formComponentShown

    private void formComponentResized(java.awt.event.ComponentEvent evt)//GEN-FIRST:event_formComponentResized
    {//GEN-HEADEREND:event_formComponentResized
// TODO add your handling code here:
    }//GEN-LAST:event_formComponentResized
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables
    
}
