---
myst:
  html_meta:
    keywords: LaTeX,typographie
---
# Doit-on mettre les accents sur les majuscules ?

Oui ! Au début de l'informatique, le codage sur 7 bits a obligé à réduire le nombre de caractères différents utilisables par les ordinateurs, et les majuscules accentuées ont paru accessoires aux concepteurs (américains) de l'époque. Ce n'est plus d'actualité. De plus, la saisie des accents sur n'importe quelle lettre est très simple en LaTeX.

Les commandes suivantes permettent de produire l'accent aigu, l'accent grave, l'accent circonflexe et le tréma. Il suffit alors de les faire suivre par les voyelles majuscules souhaitées.


| Accent          | Commande | Exemple   | Résultat |
|-----------------|----------|-----------|----------|
| aigu (´)        | `\'`     | `\'E`     | É        |
| grave (&#96;)   | `` \` `` | `` \`E `` | È        |
| circonflexe (^) | `\^`     | `\^E`     | Ê        |
| tréma (¨)       | `\"`     | `\"E`     | Ë        |


:::tip
Les commandes précédentes fonctionnent également si elles sont suivies d'une lettre minuscule, pour produire les minuscules accentuées souhaitées.
:::

Il est également possible de saisir directement les lettres majuscules accentuées au clavier, pour cela voyez les pages consacrées à la saisie des caractères spéciaux sous [macOS](/1_generalites/bases/comment_obtenir_ce_caractere_sous_macOS), [Windows](/1_generalites/bases/comment_obtenir_ce_caractere_sous_Windows) et [GNU/Linux](/1_generalites/bases/comment_obtenir_ce_caractere_sous_GNU_Linux).

Voici un exemple :

```
\begin{description}
\item[Au moyen d'une commande :] PALAIS DES CONGR\`ES
\item[Ou bien directement :] PALAIS DES CONGRÈS
\end{description}
```

Une réponse plus détaillée est donnée sur le [site Antidote](https://www.antidote.info/fr/blogue/enquetes/faut-il-accentuer-les-majuscules-et-les-capitales).
