/*
 * Copyright (C) 2022, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Nicole <buxiaoqing@kylinos.cn>
 *
 */

#ifndef KBADGE_H
#define KBADGE_H

#include <QWidget>
#include <QPixmap>
#include <QColor>
#include <QToolButton>

class KBadgePrivate;
/** @defgroup 消息提示模块
  * @{
  */

/**
 * @brief KBadge,消息提醒气泡
 */

class KBadge : public QToolButton
{
    Q_OBJECT
public:
    KBadge(QWidget *parent);

    /**
     * @brief 返回值
     * @return
     */
    int value();

    /**
     * @brief 设置值，最大显示数值为99，大于99显示"99+"
     * @param value
     */
    void setValue(int value);

    /**
     * @brief 设置值是否可见
     * @param flag
     */
    void setValueVisiable(bool flag);

    /**
     * @brief 获取值是否可见
     */
    bool isValueVisiable() const;

    /**
     * @brief 获取背景色
     * @return
     */
    QColor color();

    /**
     * @brief 设置背景色
     * @param color
     */
    void setColor(const QColor& color);

    /**
     * @brief 获取字体大小
     * @return
     */
    int fontSize();

    /**
     * @brief 设置字体大小
     * @param size
     */
    void setFontSize(int size);

    QRect geometry();
    void setGeometry(QRect rect);
    QSize updateSize();

protected:
    void paintEvent(QPaintEvent *event);
    void resizeEvent(QResizeEvent *event);

private:
    Q_DECLARE_PRIVATE(KBadge)
    KBadgePrivate*const d_ptr;
};

#endif // KBADGE_H
